---
layout: default
title: openapi resource scans
nav_order: 1
---

# openapi resource scans (auto generated)

|    | Id             | Type     | Entity              | Policy                                                                                                                                       | IaC     | Resource Link                                                                                                                                                             |
|----|----------------|----------|---------------------|----------------------------------------------------------------------------------------------------------------------------------------------|---------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
|  0 | CKV_OPENAPI_1  | resource | securityDefinitions | Ensure that securityDefinitions is defined and not empty - version 2.0 files                                                                 | OpenAPI | [SecurityDefinitions.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/openapi/checks/resource/v2/SecurityDefinitions.py)                                     |
|  1 | CKV_OPENAPI_2  | resource | security            | Ensure that if the security scheme is not of type 'oauth2', the array value must be empty - version 2.0 files                                | OpenAPI | [Oauth2SecurityRequirement.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/openapi/checks/resource/v2/Oauth2SecurityRequirement.py)                         |
|  2 | CKV_OPENAPI_3  | resource | components          | Ensure that security schemes don't allow cleartext credentials over unencrypted channel - version 3.x.y files                                | OpenAPI | [CleartextOverUnencryptedChannel.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/openapi/checks/resource/v3/CleartextOverUnencryptedChannel.py)             |
|  3 | CKV_OPENAPI_4  | resource | security            | Ensure that the global security field has rules defined                                                                                      | OpenAPI | [GlobalSecurityFieldIsEmpty.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/openapi/checks/resource/generic/GlobalSecurityFieldIsEmpty.py)                  |
|  4 | CKV_OPENAPI_5  | resource | security            | Ensure that security operations is not empty.                                                                                                | OpenAPI | [SecurityOperations.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/openapi/checks/resource/generic/SecurityOperations.py)                                  |
|  5 | CKV_OPENAPI_6  | resource | security            | Ensure that security requirement defined in securityDefinitions - version 2.0 files                                                          | OpenAPI | [SecurityRequirement.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/openapi/checks/resource/v2/SecurityRequirement.py)                                     |
|  6 | CKV_OPENAPI_7  | resource | security            | Ensure that the path scheme does not support unencrypted HTTP connection where all transmissions are open to interception- version 2.0 files | OpenAPI | [PathSchemeDefineHTTP.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/openapi/checks/resource/v2/PathSchemeDefineHTTP.py)                                   |
|  7 | CKV_OPENAPI_8  | resource | security            | Ensure that security is not using 'password' flow in OAuth2 authentication - version 2.0 files                                               | OpenAPI | [Oauth2SecurityPasswordFlow.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/openapi/checks/resource/v2/Oauth2SecurityPasswordFlow.py)                       |
|  8 | CKV_OPENAPI_9  | resource | paths               | Ensure that security scopes of operations are defined in securityDefinitions - version 2.0 files                                             | OpenAPI | [OperationObjectSecurityScopeUndefined.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/openapi/checks/resource/v2/OperationObjectSecurityScopeUndefined.py) |
|  9 | CKV_OPENAPI_10 | resource | paths               | Ensure that operation object does not use 'password' flow in OAuth2 authentication - version 2.0 files                                       | OpenAPI | [Oauth2OperationObjectPasswordFlow.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/openapi/checks/resource/v2/Oauth2OperationObjectPasswordFlow.py)         |
| 10 | CKV_OPENAPI_11 | resource | securityDefinitions | Ensure that operation object does not use 'password' flow in OAuth2 authentication - version 2.0 files                                       | OpenAPI | [Oauth2SecurityDefinitionPasswordFlow.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/openapi/checks/resource/v2/Oauth2SecurityDefinitionPasswordFlow.py)   |
| 11 | CKV_OPENAPI_12 | resource | securityDefinitions | Ensure no security definition is using implicit flow on OAuth2, which is deprecated - version 2.0 files                                      | OpenAPI | [Oauth2SecurityDefinitionImplicitFlow.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/openapi/checks/resource/v2/Oauth2SecurityDefinitionImplicitFlow.py)   |
| 12 | CKV_OPENAPI_13 | resource | securityDefinitions | Ensure security definitions do not use basic auth - version 2.0 files                                                                        | OpenAPI | [SecurityDefinitionBasicAuth.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/openapi/checks/resource/v2/SecurityDefinitionBasicAuth.py)                     |
| 13 | CKV_OPENAPI_14 | resource | paths               | Ensure that operation objects do not use 'implicit' flow, which is deprecated - version 2.0 files                                            | OpenAPI | [OperationObjectImplicitFlow.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/openapi/checks/resource/v2/OperationObjectImplicitFlow.py)                     |
| 14 | CKV_OPENAPI_15 | resource | paths               | Ensure that operation objects do not use basic auth - version 2.0 files                                                                      | OpenAPI | [OperationObjectBasicAuth.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/openapi/checks/resource/v2/OperationObjectBasicAuth.py)                           |
| 15 | CKV_OPENAPI_16 | resource | paths               | Ensure that operation objects have 'produces' field defined for GET operations - version 2.0 files                                           | OpenAPI | [OperationObjectProducesUndefined.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/openapi/checks/resource/v2/OperationObjectProducesUndefined.py)           |
| 16 | CKV_OPENAPI_17 | resource | paths               | Ensure that operation objects have 'consumes' field defined for PUT, POST and PATCH operations - version 2.0 files                           | OpenAPI | [OperationObjectConsumesUndefined.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/openapi/checks/resource/v2/OperationObjectConsumesUndefined.py)           |
| 17 | CKV_OPENAPI_18 | resource | schemes             | Ensure that global schemes use 'https' protocol instead of 'http'- version 2.0 files                                                         | OpenAPI | [GlobalSchemeDefineHTTP.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/openapi/checks/resource/v2/GlobalSchemeDefineHTTP.py)                               |
| 18 | CKV_OPENAPI_19 | resource | security            | Ensure that global security scope is defined in securityDefinitions - version 2.0 files                                                      | OpenAPI | [GlobalSecurityScopeUndefined.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/openapi/checks/resource/v2/GlobalSecurityScopeUndefined.py)                   |
| 19 | CKV_OPENAPI_20 | resource | paths               | Ensure that API keys are not sent over cleartext                                                                                             | OpenAPI | [ClearTextAPIKey.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/openapi/checks/resource/generic/ClearTextAPIKey.py)                                        |
| 20 | CKV_OPENAPI_21 | resource | paths               | Ensure that arrays have a maximum number of items                                                                                            | OpenAPI | [NoMaximumNumberItems.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/openapi/checks/resource/generic/NoMaximumNumberItems.py)                              |


---


